import app from './server.config.js';
import dotenv from 'dotenv';
import https from 'https';
import fs from 'fs';
import Logger from '../src/utils/logger.util.js';
//import TokenService from '../src/utils/token.util.mjs';

// Cargar las variables de entorno desde el archivo .env
dotenv.config();

// Declaracion del logger
const log = new Logger();

// Declaracion del tokenService
//const tokenService = new TokenService();

// Variable para determinar el entorno de ejecución (desarrollo, producción, etc.)
const MODE_DEVELOPMENT = 'Desarrollo';
const MODE_PRODUCTION = 'Produccion';
const MODE = MODE_PRODUCTION;

// Iniciar el servidor en el modo de desarrollo o producción
if( MODE === MODE_DEVELOPMENT ) {
	/**
	 * Iniciar el servidor en modo de desarrollo.
	 * @callback
	**/
	app.listen( process.env.SV_PORT , () => {
		console.info( `Aplicacion corriendo en el puerto: ${process.env.SV_PORT}\nModo: ${MODE}` );
	} );
}
else if ( MODE === MODE_PRODUCTION ) {
	// Verificar que el certificado SSL y la clave privada estén presentes
	if ( !process.env.SSL_CERT || !process.env.SSL_KEY || !process.SSL_CA ) {
		log.escribirLog( 'Error', 'No fue posible cargar los certificados' );
		throw new Error( 'Falta configurar los certificados certificado SSL o la clave privada.' );
	}

	// Cargar el certificado SSL y la clave privada desde las variables de entorno
	const options = {
		ca: fs.readFileSync( process.env.SSL_CA, 'utf8' ),
		cert: fs.readFileSync( process.env.SSL_CERT, 'utf8' ),
		key: fs.readFileSync( process.env.SSL_KEY, 'utf8' )
	};

	// Crear el servidor HTTPS con el certificado y la clave privada
	const servidor = https.createServer( options, app );

	/**
	 * Iniciar el servidor en modo de producción.
	 * @callback
	**/
	servidor.listen( process.env.SV_PORT, () => {
		console.info(`Aplicacion corriendo en el puerto: ${process.env.SV_PORT}\nModo: ${MODE}`);
	});
}

// setInterval( async () => {
// 	try {
// 		tokenService.obtenerToken();
// 	} catch ( error ) {
// 		this.escribirLog( 'Error', `\n┌ Mensaje: No fue posible obtener el token\n└ Error: ${error}` );
// 	}
// }, 86400 * 4 * 1000 );