import express from 'express';
import routes from '../src/routes/router.route.js';
//import Logger from '../src/utils/logger.util.mjs'

/**
 * Instancia de la aplicación Express.
 * @type {import('express').Express}
**/
const app = express();

// Middleware para servir archivos estáticos desde la carpeta 'logs'
//app.use('/logs', express.static('public'));

// Middleware para analizar el cuerpo de las peticiones como JSON
app.use( express.json() );

// Agregar las rutas del archivo router.route.js como middleware
app.use( '/', routes );

//const logger = new Logger();

/**
 * Ruta default: Responde con un mensaje indicando que la aplicación está corriendo.
 * Esta ruta maneja todas las solicitudes entrantes.
 * 
 * @param {import('express').Request} req - El objeto de solicitud.
 * @param {import('express').Response} res - El objeto de respuesta.
**/
app.all( '*', ( req, res ) => {
	/*logger.escribirLog(
		'Info',
		`\n┌ Ruta no encontrada: ${req.url}\n├ ip: ${req.ip}\n├ metodo: ${req.method}\n└ body: ${JSON.stringify(req.body)}`
	);*/
	// Enviar una respuesta de ruta desconocida
	res.status(404).json( { mensaje: 'Ruta no encontrada', ruta: req.url } );
});

export default app;